/*	Renegade Scripts.dll
	Example Plugin Code
	Copyright 2007 Whitedragon(MDB), Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

/*  This is designed to serve as both an example on how to make a plugin and to give users the basic framework of a plugin.
    The plugin is simple: it creates an object creation hook and attaches the script "Plugin_Example_Script" to all objects.
	The script prints out a message whenever an object is created or destroyed.
	There are also examples of the new format for bhs.dll hooks.
*/

#include "scripts.h"
#include <stdarg.h>
#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include "engine.h"
#include "gmmain.h"
#include "plugin.h"
#include "float.h"

ExampleSettingsStruct *ExampleSettings = 0;

void ExampleSettingsStruct::Load() {
	SettingsLoader::Load();


	LoadFloat(DeadPPCreditTick, "DeadPPCreditTick");
	LoadFloat(DeadRefCreditTick, "DeadRefCreditTick");
	LoadFloat(DeadPPRefCreditTick, "DeadPPRefCreditTick");

}

int ObjectHookID = 0;
ObjectCreateHookStruct *ObjectHookStruct = 0;


void ObjectHookCall(void *data,GameObject *obj) 
{
}


void Plugin_Load() {
	ExampleSettings = new ExampleSettingsStruct("dead_pp_ref_credit_tick.ini");
	ExampleSettings->Load();

	ObjectHookStruct = new ObjectCreateHookStruct;
	ObjectHookStruct->hook = ObjectHookCall;
	ObjectHookStruct->data = 0;
	ObjectHookID = AddObjectCreateHook(ObjectHookStruct);

}

void Plugin_Unload() {
	delete ExampleSettings;
	delete ObjectHookStruct;
}

void Dead_PP_Ref_Credit_Tick::Created(GameObject *o)
{
	Commands->Start_Timer(o,this,1,1);
}
 
void Dead_PP_Ref_Credit_Tick::Timer_Expired(GameObject *o,int number)
{
	if (number == 1)
	{
		float Amount = 0.0f;
		for (int Team = 0; Team < 2; Team++)
		{	
			Amount = 0.0f;
			if (Is_Building_Dead(Find_Power_Plant(Team)))
			{
				Amount = ExampleSettings->DeadPPCreditTick;
			}
			if (Is_Building_Dead(Find_Refinery(Team)))
			{
				Amount = ExampleSettings->DeadRefCreditTick;
			}
			if (Is_Building_Dead(Find_Power_Plant(Team)) && Is_Building_Dead(Find_Refinery(Team)))
			{
				Amount = ExampleSettings->DeadPPRefCreditTick;
			}
			if (Amount == 0.0f)
			{
				continue;
			}
			for (GenericSLNode* PlayerIter = PlayerList->HeadNode; (PlayerIter != NULL); PlayerIter = PlayerIter->NodeNext)
			{
				cPlayer *p = (cPlayer *)PlayerIter->NodeData;
				if (p->IsActive && Get_Team(p->PlayerId) == Team)
				{
					p->Increment_Money(Amount);
				}
			}
		}
		Commands->Start_Timer(o,this,1,1);
	}
};

ScriptRegistrant<Dead_PP_Ref_Credit_Tick> Dead_PP_Ref_Credit_Tick_Registrant("Dead_PP_Ref_Credit_Tick", "");

extern "C" {

DLLEXPORT void SSGM_Level_Loaded_Hook() 
{
	GameObject *obj = Commands->Create_Object("Invisible_Object", Vector3(0.0, 0.0, 0.0));
	Attach_Script_Once(obj, "Dead_PP_Ref_Credit_Tick", "");
}
}


